<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>JSON-LD Generator – Demo Version</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

<!-- FIX: Bootstrap Icons laden -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
.schema-box { display:none; }
.schema-box.active { display:block; }
.locked {
    opacity: 0.45;
    cursor: not-allowed !important;
}
.output-area {
    height: 260px;
    font-family: monospace;
}
.footer-box {
    margin-top: 2rem;
    font-size: 0.8rem;
    color: #9ca3af;
    text-align: center;
}
.footer-box a {
    color: #e5e7eb;
    text-decoration: none;
}
.footer-box a:hover {
    text-decoration: underline;
}
</style>
</head>

<body class="bg-light">


<div class="container py-5">

    <h1 class="mb-4">JSON-LD Generator <span class="text-primary">Demo-Version</span></h1>

    <div class="alert alert-info border-primary">
        <b>Demo-Version:</b> Nur „Article“ und „FAQ“ sind freigeschaltet.<br>
        Exportfunktionen & zusätzliche Schema-Typen sind in der 
        <a href="https://thecodeatlas.net/project.php?slug=schema_generator_premium" class="fw-bold">Premium-Version</a> enthalten.
    </div>

    <!-- Schema Navigation -->
    <ul class="nav nav-tabs mb-4">
        <li class="nav-item">
            <button class="nav-link active schema-tab" data-schema="article">Article</button>
        </li>
        <li class="nav-item">
            <button class="nav-link schema-tab" data-schema="faq">FAQ</button>
        </li>
        <li class="nav-item">
            <button class="nav-link locked" onclick="locked()">Product</button>
        </li>
        <li class="nav-item">
            <button class="nav-link locked" onclick="locked()">Event</button>
        </li>
        <li class="nav-item">
            <button class="nav-link locked" onclick="locked()">LocalBusiness</button>
        </li>
        <li class="nav-item">
            <button class="nav-link locked" onclick="locked()">Recipe</button>
        </li>
        <li class="nav-item">
            <button class="nav-link locked" onclick="locked()">Breadcrumb</button>
        </li>
        <li class="nav-item">
            <button class="nav-link locked" onclick="locked()">JobPosting</button>
        </li>
    </ul>

    <!-- Article -->
    <div id="schema-article" class="schema-box active border rounded p-3 bg-white">
        <h5>Article</h5>
        <label class="form-label">Titel</label>
        <input id="article_title" class="form-control mb-3">

        <label class="form-label">Beschreibung</label>
        <textarea id="article_desc" class="form-control mb-3"></textarea>

        <label class="form-label">Bild-URL</label>
        <input id="article_image" class="form-control mb-3">

        <label class="form-label">URL</label>
        <input id="article_url" class="form-control mb-3">
    </div>

    <!-- FAQ -->
    <div id="schema-faq" class="schema-box border rounded p-3 bg-white">
        <h5>FAQ</h5>

        <div id="faqWrapper"></div>

        <button id="addFaq" class="btn btn-outline-primary btn-sm mt-2">+ Frage hinzufügen</button>
    </div>

    <button id="btnGenerate" class="btn btn-primary mt-4 mb-3">
        JSON-LD generieren
    </button>

    <div class="alert alert-secondary d-flex align-items-center">
        <i class="bi bi-lock-fill me-2"></i>
        Export-Funktionen sind nur in der Premium-Version verfügbar.
    </div>

    <textarea id="output" class="form-control output-area" readonly></textarea>

</div>
<div class="footer-box">
        © <?php echo date('Y'); ?> <a href="https://thecodeatlas.net" target="_blank">TheCodeAtlas.net – SEO & Webmaster Tools</a>
    </div>

<script>
document.addEventListener("DOMContentLoaded", () => {

    function locked() {
        alert("Dieser Schema-Typ ist nur in der Premium-Version enthalten.");
    }

    // Switch Tabs
    document.querySelectorAll(".schema-tab").forEach(btn => {
        btn.addEventListener("click", () => {
            document.querySelectorAll(".schema-tab").forEach(b => b.classList.remove("active"));
            btn.classList.add("active");

            document.querySelectorAll(".schema-box").forEach(box => box.classList.remove("active"));
            document.getElementById("schema-" + btn.dataset.schema).classList.add("active");
        });
    });

   // FAQ Add – Sicherer HTML-Block ohne Backticks
document.getElementById("addFaq").addEventListener("click", () => {
    const wrap = document.getElementById("faqWrapper");

    const row = document.createElement("div");
    row.className = "border p-2 rounded mb-2";

    // HTML NICHT mit Backticks (``), sondern normaler string
    row.innerHTML =
        '<input class="form-control mb-2 faq-q" placeholder="Frage">' +
        '<textarea class="form-control faq-a" rows="2" placeholder="Antwort"></textarea>';

    wrap.appendChild(row);
});


    // Generate JSON-LD
    document.getElementById("btnGenerate").addEventListener("click", () => {
        const type = document.querySelector(".schema-tab.active").dataset.schema;

        let json = {
            "@context": "https://schema.org"
        };

        if (type === "article") {
            json["@type"] = "Article";
            json.headline = val("article_title");
            json.description = val("article_desc");
            json.image = val("article_image");
            json.mainEntityOfPage = val("article_url");
        }

        if (type === "faq") {
            json["@type"] = "FAQPage";
            json.mainEntity = [];

            document.querySelectorAll("#faqWrapper .faq-q").forEach((q, i) => {
                const a = document.querySelectorAll("#faqWrapper .faq-a")[i];
                if (!q.value.trim() || !a.value.trim()) return;

                json.mainEntity.push({
                    "@type": "Question",
                    name: q.value.trim(),
                    acceptedAnswer: {
                        "@type": "Answer",
                        text: a.value.trim()
                    }
                });
            });
        }

        document.getElementById("output").value =
    '<script type="application/ld+json">\n' +
    JSON.stringify(json, null, 2).replace(/<\/script>/gi, '<\\/script>') +
    '\n<\/script>';

    });

    function val(id) {
        return document.getElementById(id)?.value.trim() || "";
    }

});
</script>



</body>
</html>
