<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Broken Link Checker – Demo Version</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
body { background:#f8fafc; }
.scan-box {
    background:white;
    padding:25px;
    border-radius:14px;
    box-shadow:0 4px 15px rgba(0,0,0,0.05);
}
.result-table td {
    vertical-align: middle;
}
.badge-status {
    font-size: 13px;
    padding:5px 8px;
    border-radius:6px;
}
.badge-ok { background:#16a34a; }
.badge-redirect { background:#f59e0b; }
.badge-error { background:#dc2626; }
.badge-timeout { background:#6b7280; }
.footer {
    text-align:center;
    padding:30px;
    font-size:14px;
    color:#6b7280;
}
.export-btn {
    margin-left:8px;
}
</style>
</head>
<body>

<div class="container py-5">

   <h1 class="mb-1">Broken Link Checker <span class="text-primary">Demo Version</span></h1>

<div class="alert alert-warning mt-2">
    Diese Demo-Version zeigt nur Basisfunktionen.  
    👉 <a href="https://thecodeatlas.net/project.php?slug=broken_link_checker_pro" class="fw-bold" target="_blank">
        Premium-Version ansehen
    </a>
</div>


    <!-- INPUT -->
    <div class="scan-box mb-4">
        <label for="url" class="form-label fw-semibold">Webseite prüfen</label>
        <div class="input-group input-group-lg">
            <input type="url" id="url" class="form-control" placeholder="https://example.com" required>
            <button class="btn btn-primary" id="btnStart">
                <i class="bi bi-search"></i> Scan starten
            </button>
        </div>
        <div class="form-text">
            Die Demo-Version durchsucht nur eine Ebene.  
        </div>
    </div>

    <!-- PROGRESS -->
    <div id="progressBox" class="mb-4 d-none">
        <label class="form-label fw-semibold">Scan fortschritt</label>
        <div class="progress">
            <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated" 
                 style="width:0%"></div>
        </div>
        <div id="progressText" class="mt-2 small text-muted">Starte Crawl...</div>
    </div>

    <!-- EXPORT BUTTONS -->
    <div id="exportBar" class="mb-3 d-none text-end">
        <button class="btn btn-success export-btn disabled" id="btnExportCSV" disabled>
    <i class="bi bi-filetype-csv"></i> CSV (Premium)
</button>
<button class="btn btn-danger export-btn disabled" id="btnExportPDF" disabled>
    <i class="bi bi-filetype-pdf"></i> PDF (Premium)
</button>
<button class="btn btn-secondary export-btn disabled" id="btnExportJSON" disabled>
    <i class="bi bi-code-square"></i> JSON (Premium)
</button>
<button class="btn btn-dark export-btn disabled" id="btnExportPNG" disabled>
    <i class="bi bi-image"></i> PNG (Premium)
</button>
<script>
// Export-Buttons deaktiviert → Hinweis anzeigen
document.querySelectorAll("#exportBar button").forEach(btn => {
    btn.addEventListener("click", e => {
        e.preventDefault();
        alert("Diese Funktion ist nur in der Premium-Version verfügbar!");
    });
});
</script>

    </div>

    <!-- RESULTS -->
    <div id="results" class="d-none">
        <h4>Ergebnisse</h4>
        <table class="table table-bordered table-striped result-table">
            <thead>
                <tr>
                    <th>URL</th>
                    <th>Status</th>
                    <th>Code</th>
                </tr>
            </thead>
            <tbody id="resultBody"></tbody>
        </table>
    </div>

</div>

<div class="footer">
    © <?= date('Y') ?> TheCodeAtlas.net – SEO & Webmaster Tools
</div>

<script>
// Start Button
document.getElementById("btnStart").addEventListener("click", () => {
    let url = document.getElementById("url").value.trim();
    if (!url) return alert("Bitte eine gültige URL eingeben.");

    startScan(url);
});

// Start Scan Function
function startScan(url) {
    document.getElementById("progressBox").classList.remove("d-none");
    document.getElementById("results").classList.add("d-none");
    document.getElementById("exportBar").classList.add("d-none");

    document.getElementById("progressBar").style.width = "5%";
    document.getElementById("progressText").textContent = "Crawle Webseite...";

    fetch("crawl.php?url=" + encodeURIComponent(url))
        .then(res => res.json())
        .then(data => showResults(data))
        .catch(err => {
            console.error(err);
            alert("Fehler beim Crawlen.");
        });
}

// Show Results
function showResults(data) {

    let tbody = document.getElementById("resultBody");
    tbody.innerHTML = "";

    data.results.forEach(row => {
        let badgeClass = "badge-timeout";
        if (row.status === "OK") badgeClass = "badge-ok";
        if (row.status === "Redirect") badgeClass = "badge-redirect";
        if (row.status === "Error") badgeClass = "badge-error";

        tbody.innerHTML += `
            <tr>
                <td>${row.url}</td>
                <td><span class="badge-status ${badgeClass}">${row.status}</span></td>
                <td>${row.code}</td>
            </tr>
        `;
    });

    document.getElementById("progressBar").style.width = "100%";
    document.getElementById("progressText").textContent = "Scan abgeschlossen";

    document.getElementById("results").classList.remove("d-none");
    document.getElementById("exportBar").classList.remove("d-none");

    window.latestResultData = data; // speichern für Exporte
}

// Export CSV
document.getElementById("btnExportCSV").addEventListener("click", () => {
    let f = document.createElement("form");
    f.method = "POST";
    f.action = "export_csv.php";

    let input = document.createElement("input");
    input.type = "hidden";
    input.name = "data";
    input.value = JSON.stringify(window.latestResultData);
    f.appendChild(input);

    document.body.appendChild(f);
    f.submit();
    f.remove();
});

// Export JSON
document.getElementById("btnExportJSON").addEventListener("click", () => {
    let blob = new Blob([JSON.stringify(window.latestResultData, null, 2)], {type: "application/json"});
    let url = URL.createObjectURL(blob);

    let a = document.createElement("a");
    a.href = url;
    a.download = "broken_links.json";
    a.click();
    URL.revokeObjectURL(url);
});

// Export PNG
document.getElementById("btnExportPNG").addEventListener("click", () => {
    html2canvas(document.querySelector("#results")).then(canvas => {
        canvas.toBlob(blob => {
            let url = URL.createObjectURL(blob);
            let a = document.createElement("a");
            a.href = url;
            a.download = "broken_links.png";
            a.click();
            URL.revokeObjectURL(url);
        });
    });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>

</body>
</html>
