<?php
$ip = $_SERVER['REMOTE_ADDR'];
$file = "rate.json";

if (!file_exists($file)) file_put_contents($file, json_encode([]));
$data = json_decode(file_get_contents($file), true);

$time = time();
$limit = 5;  // 5 requests
$window = 60; // per minute

if (!isset($data[$ip])) {
    $data[$ip] = [];
}

$data[$ip] = array_filter($data[$ip], fn($t) => ($time - $t) < $window);

if (count($data[$ip]) >= $limit) {
    die("Rate limit exceeded");
}

$data[$ip][] = $time;

file_put_contents($file, json_encode($data));

echo "OK";
