/* ===========================================================
   TheCodeAtlas – Auto Copyright Footer (FREE)
   - JS-Version mit Branding
   - Fügt automatisch © YEAR + Seitentitel ein
   - Branding: "Generated with ❤️ by TheCodeAtlas"
=========================================================== */

(function () {
    if (!document || !document.body) return;

    const year = new Date().getFullYear();

    // Seitentitel etwas "aufräumen"
    let title = document.title || window.location.hostname || "Your Website";
    title = title.replace(/[\|\-–].*$/, "").trim(); // alles nach |, - oder – weg

    const line = `© ${year} ${title} · Generated with ❤️ by TheCodeAtlas`;

    // Versuchen, bestehenden Footer zu finden
    let footer = document.querySelector("footer");

    if (!footer) {
        // Fallback: eigenen Footer-Balken erstellen
        footer = document.createElement("footer");
        footer.style.position = "fixed";
        footer.style.left = "0";
        footer.style.right = "0";
        footer.style.bottom = "0";
        footer.style.padding = "8px 16px";
        footer.style.background = "rgba(15, 23, 42, 0.92)";
        footer.style.color = "#e5e7eb";
        footer.style.fontFamily = "system-ui, -apple-system, BlinkMacSystemFont, sans-serif";
        footer.style.fontSize = "13px";
        footer.style.textAlign = "center";
        footer.style.zIndex = "999999";
        footer.style.boxShadow = "0 -2px 8px rgba(0,0,0,0.25)";
        document.body.appendChild(footer);
    }

    // Inneren Wrapper hinzufügen, damit wir nicht alles überschreiben
    const bar = document.createElement("div");
    bar.textContent = line;
    bar.style.opacity = "0.95";

    // Wenn Footer schon Inhalt hat, nur eine kleine Zeile ergänzen
    if (footer.children.length > 0) {
        bar.style.marginTop = "6px";
        bar.style.fontSize = "12px";
        bar.style.color = "#9ca3af";
    }

    footer.appendChild(bar);
})();
