<?php
/*
===========================================================
 OpenGraph Image Generator – PREMIUM (TRIAL VERSION)
 Idee & Umsetzung: Rainer Wieding – https://thecodeatlas.net
 Technische Unterstützung: ChatGPT (OpenAI)
===========================================================
*/
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>OpenGraph Image Generator – Premium (Trial)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
body {
    background: radial-gradient(circle at top, #1e1b4b 0, #020617 45%, #020617 100%);
    min-height: 100vh;
    color: #e5e7eb;
    font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
}

.card-glass {
    background: rgba(15, 23, 42, 0.95);
    border-radius: 18px;
    border: 1px solid rgba(148, 163, 184, 0.4);
    box-shadow: 0 22px 60px rgba(15, 23, 42, 0.85);
}

.form-label {
    color: #aebac9;
    font-weight: 600;
    font-size: 0.9rem;
}

/* Inputs */
input,
textarea,
select {
    color: #1f2937 !important;
    background:#ffffff !important;
    border-color:#cbd5e1 !important;
}
input::placeholder,
textarea::placeholder {
    color:#6b7280 !important;
}

/* Preview Wrapper */
#previewFrame {
    background: #020617;
    border-radius: 16px;
    padding: 18px;
    border: 1px solid rgba(148, 163, 184, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
}

/* OG Preview Canvas */
.og-preview {
    position: relative;
    border-radius: 24px;
    overflow: hidden;
    color: #f9fafb;
    display: flex;
    flex-direction: column;
    padding: 32px;
    box-shadow: 0 18px 40px rgba(15, 23, 42, 0.8);
    background: linear-gradient(135deg, #312e81, #1e293b);
}

/* Formate */
.og-format-1200x630 { width:960px; height:504px; }
.og-format-1200x628 { width:960px; height:502px; }
.og-format-1080x1080 { width:480px; height:480px; }

/* Template basics */
.og-top-row {
    display:flex; justify-content:space-between; align-items:center;
    gap:12px; font-size:0.8rem;
    text-transform:uppercase; letter-spacing:.12em;
}
.og-category-badge {
    padding:4px 10px; border-radius:999px;
    background:rgba(15,23,42,0.6);
    border:1px solid rgba(148,163,184,0.7);
    font-weight:600;
}
.og-domain { opacity:0.9; }

.og-main {
    flex:1; display:flex; flex-direction:column;
    justify-content:center; gap:10px; margin-top:18px;
}
.og-title { font-size:2.2rem; line-height:1.15; font-weight:800; }
.og-subtitle { font-size:1rem; max-width:80%; opacity:0.9; }

/* Logo */
.og-logo-wrap {
    position:absolute; right:26px; bottom:24px;
    width:96px; height:96px; border-radius:20px;
    background:rgba(15,23,42,0.7); border:1px solid rgba(148,163,184,0.7);
    display:flex; justify-content:center; align-items:center;
    overflow:hidden;
}
.og-logo-wrap img { max-width:100%; max-height:100%; }

/* Template Variants */
.template-1 .og-main { align-items:flex-start; }
.template-2 .og-main { flex-direction:row; align-items:center; gap:24px; }
.template-2 .og-main-text { flex:2; }
.template-2 .og-main-accent { flex:1; height:70%; border-radius:24px;
    background:rgba(15,23,42,0.45); }
.template-3 .og-main { justify-content:flex-end; }
.template-3 .og-title { font-size:2.5rem; }

/* TRIAL Wasserzeichen */
.pro-watermark {
    position:absolute;
    inset:0;
    display:flex;
    justify-content:center;
    align-items:center;
    font-size:3rem;
    font-weight:900;
    color:#ffffff;
    opacity:0.20;
    transform:rotate(-30deg);
    pointer-events:none;
    z-index:999;
    text-transform:uppercase;
}

/* Footer */
.footer-box {
    margin-top:2rem; font-size:0.8rem; color:#aebac9; text-align:center;
}
.footer-box a { color:#e5e7eb; text-decoration:none; }
.footer-box a:hover { text-decoration:underline; }

</style>
</head>
<body>

<div class="container py-5">
    <div class="row justify-content-center mb-4">
        <div class="col-lg-10">
            <h1 class="h3 mb-1">OpenGraph Image Generator <span class="text-info">Premium</span> <span class="badge bg-warning text-dark ms-2">Trial</span></h1>
            <div class="text-muted small">
                Diese Trial-Version enthält ein dauerhaftes Wasserzeichen. Die Premium-Version exportiert Bilder ohne Einschränkungen.
            </div>
        </div>
    </div>

    <!-- Main Card -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card card-glass">
                <div class="card-body">
                    <div class="row g-4">

                        <!-- FORMULAR -->
                        <div class="col-lg-5">
                            <h5 class="mb-3">Einstellungen</h5>

                            <label class="form-label">Template</label>
                            <select id="tplSelect" class="form-select form-select-sm mb-3">
                                <option value="template-1">Template 1 – Fokus Headline</option>
                                <option value="template-2">Template 2 – Text & Accent Panel</option>
                                <option value="template-3">Template 3 – Bold Headline</option>
                            </select>

                            <label class="form-label">Format</label>
                            <select id="formatSelect" class="form-select form-select-sm mb-3">
                                <option value="1200x630">1200 × 630</option>
                                <option value="1200x628">1200 × 628</option>
                                <option value="1080x1080">1080 × 1080</option>
                            </select>

                            <hr class="border-secondary-subtle">

                            <label class="form-label">Titel</label>
                            <input type="text" id="titleInput" class="form-control form-control-sm mb-3"
                                   placeholder="Beispiel: OpenGraph Generator Premium">

                            <label class="form-label">Untertitel</label>
                            <textarea id="subtitleInput" rows="2"
                                      class="form-control form-control-sm mb-3"
                                      placeholder="Kurze Erklärung oder Nutzenversprechen."></textarea>

                            <label class="form-label">Kategorie / Badge</label>
                            <input type="text" id="badgeInput" class="form-control form-control-sm mb-3"
                                   placeholder="z. B. SEO Tool">

                            <label class="form-label">Website / Domain</label>
                            <input type="text" id="domainInput" class="form-control form-control-sm mb-3"
                                   placeholder="thecodeatlas.net">

                            <hr class="border-secondary-subtle">

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Primärfarbe</label>
                                    <input type="color" id="colorPrimary" class="form-control form-control-color" value="#6366f1">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Akzentfarbe</label>
                                    <input type="color" id="colorAccent" class="form-control form-control-color" value="#a855f7">
                                </div>
                            </div>

                            <label class="form-label mt-3">Logo Upload (optional)</label>
                            <input type="file" id="logoInput" class="form-control form-control-sm" accept="image/*">

                            <div class="mt-4 d-grid">
                                <button type="button" id="btnExportPNG" class="btn btn-success">
                                    <i class="bi bi-download me-1"></i> PNG exportieren (Trial)
                                </button>
                            </div>

                            <div class="mt-3">
                                <a href="https://thecodeatlas.net/project.php?slug=opengraph_image_generator_pro" 
                                   target="_blank"
                                   class="btn btn-outline-light btn-sm w-100">
                                    <i class="bi bi-unlock-fill me-1"></i> Vollversion & Preise ansehen
                                </a>
                            </div>
                        </div>

                        <!-- PREVIEW -->
                        <div class="col-lg-7">
                            <h5 class="mb-2">Live Vorschau</h5>

                            <div id="previewFrame">
                                <div id="ogPreview" class="og-preview template-1 og-format-1200x630">
                                    <div class="pro-watermark">TRIAL VERSION</div>

                                    <div class="og-top-row">
                                        <div class="og-category-badge" id="previewBadge">SEO Tool</div>
                                        <div class="og-domain" id="previewDomain">thecodeatlas.net</div>
                                    </div>

                                    <div class="og-main">
                                        <div class="og-main-text">
                                            <div class="og-title" id="previewTitle">OpenGraph Image Generator – Premium</div>
                                            <div class="og-subtitle" id="previewSubtitle">
                                                Testversion mit Wasserzeichen. Die Vollversion exportiert saubere OG-Bilder.
                                            </div>
                                        </div>
                                        <div class="og-main-accent d-none"></div>
                                    </div>

                                    <div class="og-logo-wrap" id="logoWrap" style="display:none;">
                                        <img id="previewLogo" alt="">
                                    </div>
                                </div>
                            </div>

                            <p class="small text-muted mt-2">
                                Diese Trial-Version zeigt das Wasserzeichen dauerhaft. Die Vollversion entfernt alle Einschränkungen.
                            </p>
                        </div>

                    </div>
                </div>
            </div>

            <div class="footer-box">
                © <?= date('Y') ?> TheCodeAtlas.net – Trial-Version der Premium Edition.
            </div>

        </div>
    </div>
</div>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>

<script>
(function(){
    const trialMode = true;

    const ogPreview    = document.getElementById('ogPreview');
    const previewTitle = document.getElementById('previewTitle');
    const previewSubtitle = document.getElementById('previewSubtitle');
    const previewBadge = document.getElementById('previewBadge');
    const previewDomain = document.getElementById('previewDomain');
    const previewLogo = document.getElementById('previewLogo');
    const logoWrap = document.getElementById('logoWrap');

    const titleInput = document.getElementById('titleInput');
    const subtitleInput = document.getElementById('subtitleInput');
    const badgeInput = document.getElementById('badgeInput');
    const domainInput = document.getElementById('domainInput');
    const colorPrimary = document.getElementById('colorPrimary');
    const colorAccent = document.getElementById('colorAccent');
    const tplSelect = document.getElementById('tplSelect');
    const formatSelect = document.getElementById('formatSelect');
    const logoInput = document.getElementById('logoInput');
    const btnExportPNG = document.getElementById('btnExportPNG');

    const mainAccent = ogPreview.querySelector('.og-main-accent');

    function val(el){ return (el.value || '').trim(); }

    function updatePreview(){
        previewTitle.textContent = val(titleInput) || "OpenGraph Image Generator – Premium";
        previewSubtitle.textContent = val(subtitleInput) || "Testversion mit Wasserzeichen. Die Vollversion exportiert saubere OG-Bilder.";
        previewBadge.textContent = val(badgeInput) || "SEO Tool";
        previewDomain.textContent = val(domainInput) || "thecodeatlas.net";

        const c1 = val(colorPrimary) || "#6366f1";
        const c2 = val(colorAccent) || "#a855f7";
        ogPreview.style.background = "linear-gradient(135deg," + c1 + "," + c2 + ")";

        ogPreview.classList.remove("template-1","template-2","template-3");
        ogPreview.classList.add(tplSelect.value);

        ogPreview.classList.remove("og-format-1200x630","og-format-1200x628","og-format-1080x1080");
        ogPreview.classList.add("og-format-" + formatSelect.value);

        if (mainAccent){
            if (tplSelect.value === "template-2"){
                mainAccent.classList.remove("d-none");
                mainAccent.style.background = "linear-gradient(160deg, rgba(15,23,42,0.9), rgba(15,23,42,0.3))";
            } else {
                mainAccent.classList.add("d-none");
            }
        }
    }

    logoInput.addEventListener('change', function(){
        const file = logoInput.files?.[0];
        if (!file){
            logoWrap.style.display="none";
            previewLogo.src="";
            return;
        }
        const reader = new FileReader();
        reader.onload = e => {
            previewLogo.src = e.target.result;
            logoWrap.style.display = "flex";
        };
        reader.readAsDataURL(file);
    });

    [titleInput, subtitleInput, badgeInput, domainInput].forEach(el => el.addEventListener("input", updatePreview));
    [colorPrimary, colorAccent, tplSelect, formatSelect].forEach(el => el.addEventListener("input", updatePreview));

    updatePreview();

    btnExportPNG.addEventListener("click", function(){
        html2canvas(ogPreview, {
            backgroundColor: null,
            useCORS: true,
            scale: 2
        }).then(canvas => {
            canvas.toBlob(function(blob){
                if (!blob) return;
                const url = URL.createObjectURL(blob);
                const a = document.createElement("a");
                let name = val(titleInput) || "og-image-trial";
                name = name.toLowerCase().replace(/\s+/g,"-").replace(/[^a-z0-9\-]/g,"");
                a.href = url;
                a.download = name + "-trial.png";
                a.click();
                URL.revokeObjectURL(url);
            });
        });
    });

})();
</script>

</body>
</html>
