<?php
/*
===========================================================
 SEO Title Roast & Einwand-Killer
 Idee & Umsetzung: Rainer Wieding – TheCodeAtlas.net
 Technische Unterstützung: ChatGPT (OpenAI)
===========================================================
*/
error_reporting(E_ALL);
ini_set('display_errors', 1);

$result = null;
$error  = '';

function fetchHtml(string $url): ?string {
    if (!preg_match('~^https?://~i', $url)) {
        $url = 'https://' . $url;
    }
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CONNECTTIMEOUT => 8,
        CURLOPT_TIMEOUT        => 15,
        CURLOPT_USERAGENT      => 'TheCodeAtlas SEO Title Roaster',
    ]);
    $html = curl_exec($ch);
    $err  = curl_error($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($err || !$html || $code >= 400) {
        return null;
    }
    return $html;
}

function parseMeta(string $html): array {
    $dom = new DOMDocument();
    @$dom->loadHTML($html);

    $xpath = new DOMXPath($dom);

    // Title
    $titleNode = $xpath->query('//title')->item(0);
    $title = $titleNode ? trim($titleNode->textContent) : '';

    // Meta description
    $descrNode = $xpath->query('//meta[translate(@name,"ABCDEFGHIJKLMNOPQRSTUVWXYZ","abcdefghijklmnopqrstuvwxyz")="description"]')
                       ->item(0);
    $description = '';
    if ($descrNode && $descrNode->hasAttribute('content')) {
        $description = trim($descrNode->getAttribute('content'));
    }

    return [
        'title'       => $title,
        'description' => $description,
    ];
}

function analyseSeo(array $meta, string $url): array {
    $title = $meta['title'] ?? '';
    $desc  = $meta['description'] ?? '';

    $issues = [];
    $excuse = '';
    $reply  = '';
    $exampleTitle = '';
    $exampleDesc  = '';

    $titleLen = mb_strlen($title);
    $descLen  = mb_strlen($desc);

    // Typische Probleme
    if ($title === '') {
        $issues[] = 'Kein &lt;title&gt;-Tag gefunden.';
        $excuse = '„Google liest sich schon irgendwie durch, der Title ist nicht so wichtig.“';
        $reply  = 'Ohne Title schenkst du Klicks her – der Title ist der erste Eindruck in den SERPs. '
                 .'Wer hier nichts anbietet, braucht sich über schlechte Sichtbarkeit nicht wundern.';
        $exampleTitle = 'Beispiel: „SEO Tools für Webmaster & Agenturen – Jetzt Sichtbarkeit steigern“';
    } elseif ($titleLen < 20) {
        $issues[] = "Title sehr kurz ({$titleLen} Zeichen).";
        $excuse = '„Kurz ist doch knackig, oder?“';
        $reply  = 'Kurz ist okay, aber dein Title wirkt eher wie ein Fragment als ein Versprechen. '
                 .'Gib dem Nutzer wenigstens einen klaren Nutzen oder Kontext mit.';
        $exampleTitle = 'Beispiel: „Lottozahlen Statistik 1955–2025 – Häufigste Zahlen & Profi-Auswertung“';
    } elseif ($titleLen > 70) {
        $issues[] = "Title sehr lang ({$titleLen} Zeichen, Gefahr: abgeschnitten).";
        $excuse = '„Lieber alles reinpacken, irgendwas wird schon ziehen.“';
        $reply  = 'Ein überlanger Title ist wie ein Flyer mit Mikroschrift: theoretisch steht alles drauf, '
                 .'praktisch liest es niemand. Fokussiere dich auf den wichtigsten Nutzen + klare Keyword-Orientierung.';
        $exampleTitle = 'Beispiel: „OpenGraph Generator für WordPress & PHP – Perfekte Social Previews in Minuten“';
    }

    // Generischer Title?
    $genericPatterns = ['startseite', 'home', 'willkommen', 'index'];
    $lower = mb_strtolower($title);
    foreach ($genericPatterns as $pattern) {
        if (mb_strpos($lower, $pattern) !== false) {
            $issues[] = 'Title wirkt generisch (z. B. „Startseite“ / „Home“).';
            if ($excuse === '') {
                $excuse = '„Unsere Marke kennt man, da reicht ‚Startseite‘ schon.“';
                $reply  = 'Wenn dein Brand schon weltbekannt wäre, würdest du dieses Tool vermutlich nicht benutzen. '
                         .'Die SERP ist kein Ort für Platzhalter – nutze den Title, um Relevanz und Nutzen zu zeigen.';
                $exampleTitle = 'Beispiel: „Webentwicklung & SEO für KMU – Agentur Musterstadt“ statt „Startseite“.';
            }
            break;
        }
    }

    // Description
    if ($desc === '') {
        $issues[] = 'Keine Meta-Description gefunden.';
        if ($excuse === '') {
            $excuse = '„Google baut sich die Description eh selbst zusammen.“';
            $reply  = 'Ja, Google kann Description-Snippets generieren – aber warum solltest du die Kontrolle freiwillig abgeben? '
                     .'Eine klare Description mit Nutzenversprechen erhöht deine CTR und damit deine Sichtbarkeit.';
            $exampleDesc = 'Beispiel: „Entdecke unsere SEO-Tools für Webmaster, Agenturen und Shops – '
                          .'mehr Sichtbarkeit, bessere Previews, klare Reports.“';
        }
    } elseif ($descLen < 50) {
        $issues[] = "Description sehr kurz ({$descLen} Zeichen).";
        if ($excuse === '') {
            $excuse = '„Ich wollte es minimal halten.“';
            $reply  = 'Minimal ist gut – aber deine Description wirkt eher wie ein abgebrochener Satz. '
                     .'Nutze den Platz, um Neugier zu wecken und einen klaren Mehrwert zu formulieren.';
            $exampleDesc = 'Beispiel: „Analysiere Meta-Tags, Social-Previews & Schema mit einem Klick – perfekt für '
                          .'SEO-Audits und Kundenreports.“';
        }
    } elseif ($descLen > 180) {
        $issues[] = "Description sehr lang ({$descLen} Zeichen, mögliche Kürzung in den SERPs).";
        if ($excuse === '') {
            $excuse = '„Ich wollte alles genau erklären.“';
            $reply  = 'In den SERPs hast du nur ein kleines Schaufenster, keinen Roman. '
                     .'Konzentriere dich auf das Wichtigste: Problem, Lösung, Nutzen, Call-to-Action.';
            $exampleDesc = 'Beispiel: „Erzeuge saubere UTM-Links, OpenGraph-Bilder und Reports – '
                          .'Tools für Webmaster, die mehr Sichtbarkeit wollen.“';
        }
    }

    if (empty($issues)) {
        $issues[] = 'Kein gravierendes Problem erkannt. Title & Description wirken grundsätzlich brauchbar.';
        $excuse = '„Passt doch alles – muss ich da noch was machen?“';
        $reply  = 'Wenn deine Zahlen (CTR, Rankings, Conversions) stimmen: alles gut. '
                 .'Wenn nicht, probier A/B-Varianten: mehr Nutzen, klarere Zielgruppe, stärkerer Hook.';
    }

    return [
        'url'          => $url,
        'title'        => $title,
        'description'  => $desc,
        'issues'       => $issues,
        'excuse'       => $excuse,
        'reply'        => $reply,
        'exampleTitle' => $exampleTitle,
        'exampleDesc'  => $exampleDesc,
        'titleLen'     => $titleLen,
        'descLen'      => $descLen,
    ];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $url = trim($_POST['url'] ?? '');
    if ($url === '') {
        $error = 'Bitte eine URL eingeben.';
    } else {
        $html = fetchHtml($url);
        if (!$html) {
            $error = 'Die Seite konnte nicht geladen werden (Timeout, Fehler oder HTTP 4xx/5xx).';
        } else {
            $meta   = parseMeta($html);
            $result = analyseSeo($meta, $url);
        }
    }
}
?>
<!doctype html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>SEO Title Roast & Einwand-Killer – TheCodeAtlas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<style>
body {
    background: radial-gradient(circle at top, #151935 0, #050814 55%, #02040b 100%);
    color:#f5f7ff;
    font-family: system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif;
}
.card-premium {
    background: radial-gradient(circle at 0 0, rgba(156,136,255,0.15), rgba(5,8,20,0.96));
    border-radius:1.4rem;
    border:1px solid rgba(255,255,255,0.06);
    padding:1.8rem;
    box-shadow:0 22px 55px rgba(0,0,0,0.55);
}
.form-label {
    font-weight:600;
    color:#dfe7ff;
}
.form-control {
    background:#0f1629;
    border:1px solid rgba(255,255,255,0.16);
    color:#e9ecff !important;
    border-radius:0.9rem;
}
.form-control:focus {
    background:#0f1931;
    border-color:#00a8ff;
    box-shadow:0 0 0 0.15rem rgba(0,168,255,0.35);
}
.btn-premium {
    display:inline-block;
    background:linear-gradient(135deg,#9c88ff,#00a8ff);
    border:none;
    border-radius:1rem;
    padding:0.8rem 1.6rem;
    font-weight:700;
    font-size:1.0rem;
    color:#050814 !important;
    text-decoration:none;
    box-shadow:0 8px 22px rgba(0,168,255,0.25);
}
.btn-premium:hover {
    opacity:0.92;
    transform:translateY(-1px);
}
.issue-badge {
    display:inline-block;
    margin-right:0.4rem;
    margin-bottom:0.3rem;
    padding:0.25rem 0.6rem;
    border-radius:999px;
    background:rgba(248,113,113,0.15);
    border:1px solid rgba(248,113,113,0.6);
    font-size:0.8rem;
}
.meta-box {
    background:rgba(5,8,20,0.85);
    border:1px solid rgba(148,163,184,0.4);
    border-radius:1rem;
    padding:1rem 1.2rem;
    font-size:0.9rem;
}
.footer-box {
    text-align:center;
    margin-top:3rem;
    padding:1.5rem 0;
    color:#8a92b5;
    font-size:0.85rem;
}
.footer-box a {
    color:#b7beff;
    text-decoration:none;
}
.footer-box a:hover {
    text-decoration:underline;
}
</style>
</head>
<body>

<div class="container py-5">
    <h1 class="mb-1">
        <i class="fa-solid fa-fire-flame-curved me-2 text-danger"></i>
        SEO Title Roast & Einwand-Killer
    </h1>
    <p class="text-muted mb-4" style="color:#a0a0a0 !important;">
        Gib eine URL ein und lass dir sagen, was dein &lt;title&gt; und deine Meta-Description wirklich über
        deine Sichtbarkeit verraten – inklusive typischer „SEO ist doch egal“-Einwände und passenden Antworten.
    </p>

    <div class="row g-4">
        <div class="col-lg-4">
            <div class="card-premium h-100">
                <h2 class="h5 mb-3">
                    <i class="fa-solid fa-link me-2 text-info"></i>
                    URL prüfen
                </h2>
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">URL</label>
                        <input type="text"
                               name="url"
                               class="form-control"
                               placeholder="z. B. https://thecodeatlas.net/"
                               value="<?= isset($_POST['url']) ? htmlspecialchars($_POST['url']) : '' ?>"
                               required>
                    </div>
                    <button class="btn-premium" type="submit">
                        Prüfen & roasten
                    </button>
                </form>
                <p class="mt-3 small text-muted" style="color:#9ca3af !important;">
                    Hinweis: Das Tool lädt nur HTML und liest &lt;title&gt; und Meta-Description – es führt
                    keinen vollständigen Crawler aus.
                </p>
            </div>
        </div>

        <div class="col-lg-8">
            <div class="card-premium h-100">
                <h2 class="h5 mb-3">
                    <i class="fa-solid fa-magnifying-glass-chart me-2 text-warning"></i>
                    Analyse & Einwand-Killer
                </h2>

                <?php if ($error): ?>
                    <div class="alert alert-danger">
                        <?= htmlspecialchars($error) ?>
                    </div>
                <?php elseif ($result): ?>
                    <div class="mb-3">
                        <strong>Geprüfte URL:</strong>
                        <a href="<?= htmlspecialchars($result['url']) ?>"
                           target="_blank" rel="noopener"
                           class="text-decoration-underline">
                            <?= htmlspecialchars($result['url']) ?>
                        </a>
                    </div>

                    <div class="meta-box mb-3">
                        <div class="mb-2">
                            <strong>Title</strong>
                            <span class="ms-1 small text-muted">(<?= $result['titleLen'] ?> Zeichen)</span><br>
                            <?= $result['title'] ? htmlspecialchars($result['title']) : '<em>— nicht vorhanden —</em>' ?>
                        </div>
                        <div>
                            <strong>Meta-Description</strong>
                            <span class="ms-1 small text-muted">(<?= $result['descLen'] ?> Zeichen)</span><br>
                            <?= $result['description'] ? htmlspecialchars($result['description']) : '<em>— nicht vorhanden —</em>' ?>
                        </div>
                    </div>

                    <div class="mb-3">
                        <?php foreach ($result['issues'] as $issue): ?>
                            <span class="issue-badge">
                                <i class="fa-solid fa-circle-exclamation me-1"></i><?= $issue ?>
                            </span>
                        <?php endforeach; ?>
                    </div>

                    <div class="mb-3">
                        <strong>Typischer Einwand:</strong><br>
                        <em><?= htmlspecialchars($result['excuse']) ?></em>
                    </div>

                    <div class="mb-3">
                        <strong>Antwort (leicht provokant):</strong><br>
                        <?= htmlspecialchars($result['reply']) ?>
                    </div>

                    <?php if ($result['exampleTitle'] || $result['exampleDesc']): ?>
                        <div class="mb-2">
                            <strong>Konkretes Praxisbeispiel:</strong><br>
                            <?php if ($result['exampleTitle']): ?>
                                <?= htmlspecialchars($result['exampleTitle']) ?><br>
                            <?php endif; ?>
                            <?php if ($result['exampleDesc']): ?>
                                <?= htmlspecialchars($result['exampleDesc']) ?><br>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>

                    <p class="small text-muted mb-0" style="color:#9ca3af !important;">
                        Nutze die Hinweise als Ausgangspunkt: Teste alternative Titles & Descriptions,
                        beobachte CTR und Rankings und entscheide datenbasiert – nicht nach Bauchgefühl.
                    </p>
                <?php else: ?>
                    <p class="text-muted">
                        Noch keine Analyse – gib oben eine URL ein und klicke auf „Prüfen & roasten“.
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="footer-box">
        © <?= date('Y') ?> <a href="https://thecodeatlas.net" target="_blank" rel="noopener">
            TheCodeAtlas – SEO & Webmaster Tools
        </a>
    </div>
</div>

</body>
</html>
